## Cactus <img src="https://i.imgur.com/mSwZJmr.png" height="35"/>

***A Modern Version Switcher, Character Isolator, and Mod Manager for Diablo II (Original, Not Resurrected)***

***By: Jonathan Vasquez (fearedbliss)***

***Build: 2025-06-16-2100***

[**Patch Notes**](PATCH-NOTES.md) | [**Videos**](https://youtube.com/@fearedbliss) | [**Ports Collection**](<./4. Ports/PORTS-COLLECTION.md>) | [**Forum**](https://themovingcaravan.com/) | <a href="https://liberapay.com/fearedbliss/donate"><img alt="Donate using Liberapay" src="https://liberapay.com/assets/widgets/donate.svg"></a>

## Download

The Cactus (Core) source code can be downloaded at the
[Cactus (Core)](https://codeberg.org/fearedbliss/Cactus-Core) repo.

The complete Cactus package is available as a direct download from my server
(uptime is not guaranteed). [7-Zip](https://www.7-zip.org/download.html) must be
used to extract the archive since I'm using Ultra compression. All releases are
hashed and PGP signed with the key: **`34DA 858C 1447 509E C77A D49F FB85 90B7 C4CA 5279`**,
which can be found at the link below.

- ### [Download Cactus](https://themovingcaravan.com/diablo/Cactus.7z)
- ### [PGP Public Key](https://keys.openpgp.org/search?q=34DA+858C+1447+509E+C77A+D49F+FB85+90B7+C4CA+5279)
- ### [Latest Release Hash](https://themovingcaravan.com/diablo/Cactus.7z.SHA256.txt)
- ### [Latest Release Hash Signature](https://themovingcaravan.com/diablo/Cactus.7z.SHA256.txt.sig)

## License

Released under the **[Simplified BSD License](LICENSE.txt)**.

## Requirements

- **Windows 7 SP1 (x86/x64), Windows 10 22H2 (x86/x64), or Wine (FreeBSD/Linux)**
    - **[Windows 11+ will not be supported](#windows-11-will-not-be-supported)**.
- **.NET Framework 4.5.2 or Wine Mono (Cactus)**
- **Visual C++ 2015 - 2022 Redistributable (x86) (DSOAL w/ OpenAL Soft)**

## Screenshots

### Light Mode
![Cactus](https://i.imgur.com/WxaFx2S.png)

### Dark Mode
![Cactus](https://i.imgur.com/w6d7kcZ.png)

### Out Of The Box Experience
![Cactus](https://i.imgur.com/VH4RePb.png)

### Settings (19 Material Design Colors Available + Light/Dark Mode)
![Cactus](https://i.imgur.com/4BVnLTQ.png)

### Add Entry
![Cactus](https://i.imgur.com/eN8Q01K.png)

### Edit Entry
![Cactus](https://i.imgur.com/ZnUeq0E.png)

### About Page
![Cactus](https://i.imgur.com/MW19iGy.png)

### Runs Completely Offline Even In An Isolated Environment
![Cactus](https://i.imgur.com/RfPDLca.png)

### Runs on [Wine](README-CACTUS-ON-WINE.md) (FreeBSD / Linux)
![Cactus](https://i.imgur.com/VMkoSFZ.png)
![Cactus](https://i.imgur.com/SlpiHKR.png)

## History

Cactus started out as just a simple application that allowed you to
easily and efficiently Time Travel between every version of Diablo II
that ever came out, while maximizing disk space, and enabling full
character isolation between versions. However, even though Cactus itself
still is just that, the Cactus Repository has evolved to become a
centralized and historical archive, that aims to preserve every single
Diablo II version that exists (***Official Retail*** and ***Official Beta***
Releases), and has also become an ecosystem where mod developers can distribute
their mods on. Cactus is a complete rewrite from scratch of my previous
application called ***Bliss Version Switcher***. However, since Cactus is
written in C#, it behaves as a native Windows application and allows it
to integrate natively with the system. On the other hand, Bliss Version
Switcher was written in Java and there were many limitations that lead to the
Cactus rewrite.

This repository also includes several other utilities that I have either
created, or collected, which can help you play ***Vanilla*** Diablo II
better. All Cactus Platforms are ***Vanilla*** by default. The only fix
I made to all Platforms below 1.12 is to remove the CD requirement,
since modern computers no longer have a CD drive. Blizzard already did
this exact thing for all versions starting with 1.12. Other than that,
the only other modifications I provide are through
[**Singling**](README-SINGLING.md), which only contains
***non-gameplay modifications*** and is ***completely opt-in***.

If you will be playing online, you should make a copy of the Vanilla Platform
and use that one to connect to Battle.net (for example, copying the **1.14d**
platform, and calling it something like **1.14d BNET**). You can use your other
platforms with the Singling changes for local play.

The **cnc-ddraw** video renderer, and **DSOAL w/ OpenAL Soft** are included as
a ***shared resource*** for all platforms. cnc-ddraw is provided to improve
video compatibility for all versions between **`1.00`** to **`1.14d`**.
DSOAL w/ OpenAL Soft is provided to enable you to use the following lost
in-game sound functionality: 3D Sound, Environmental Effects, 3D Bias.

Cactus can also be used for ***easily playing mods in an isolated and safe fashion.***
Please check out the ***[Cactus Ports Collection](PORTS-COLLECTION.md)*** for a
list of mods that have either been ported to Cactus, attempted to be ported to
Cactus, or were made to run on Cactus natively. You'll also find the compatibility
statuses for each mod listed, and a dedicated page containing important info.

Cactus requires a purchased copy of ***Diablo II (Original, Not Resurrected)***
from Blizzard in order to have all of the game assets stored in the MPQs. Once
you have these, they will be reused for all platforms.

For more information, please read the documentation below for anything you are
interested in exploring.

## Cactus Repository

The following opt-in modifications and utilities are available in this repository:

### [Singling](README-SINGLING.md)

A collection of non-gameplay modifications and fixes in order to improve the
Vanilla Diablo II Single Player & LAN Experience.

To use Singling, simply copy the Singling files for the version you want to
play from the **`2. Singling/1. Files`** folder, and replace the ones for
the equivalent version in your Platforms directory. To revert, use the files
in **`2. Singling/2. Stock`** instead.

### [Renderers](README-RENDERERS.md)

Cactus includes and promotes the **`cnc-ddraw`** video renderer for
Diablo II versions **`1.00 - 1.14d`**, which can help you run the game
on newer systems with a higher window resolution (not a higher internal
resolution), and the ability to use shaders to upscale the quality of
the graphics in the game.

Please read the [**`README-RENDERERS`**](README-RENDERERS.md) for more info.

- [**`cnc-ddraw`**](https://github.com/CnCNet/cnc-ddraw) - This renderer
  reimplements the DirectDraw API for GDI, OpenGL, and Direct3D to improve
  compatibility with Windows XP - 10, and Wine. This renderer also supports
  the use of custom shaders - which will allow you to upscale the game so it
  looks a lot better - and even provides hotkeys (such as **`[Alt] + [Enter]`**)
  to switch between full screen and window mode.

### [3D Sound (DSOAL w/ OpenAL Soft)](README-3D-SOUND.md)

Cactus includes the files required to allow you to enable the following
lost in-game sound functionality: **`3D Sound`**, **`Environmental Effects`**,
and **`3D Bias`**.

Please read the [**`README-3D-SOUND`**](README-3D-SOUND.md) for more information.

## Installation Instructions

- [**Cactus Setup & Demo Video (2.6.6+) (58 Minutes)**](https://xyinn.org/diablo/videos/01.%20Cactus%20Installation%20Video.mp4)

### Required Files

After you finish installing Diablo II (or restoring the files from a backup),
you only need to keep the following files in your **`Diablo II Root Directory`**.
Everything else can be deleted since it will come from Cactus. Once you are done,
continue with the Cactus installation steps.

```
- D2.LNG
- D2Char.mpq
- D2Data.mpq
- D2Exp.mpq      (1.07+)
- D2Music.mpq    (Not needed for 1.00)
- D2Sfx.mpq
- D2Speech.mpq
- D2Video.mpq
- D2XMusic.mpq   (1.07+)
- D2XTalk.mpq    (1.07+)
- D2XVideo.mpq   (1.07+)
```

### Install Cactus, Dependencies, and Prepare MPQs.

This section will help you install Cactus to the correct location, its
dependencies, and also help you fix your MPQs so that they are compatible with
older versions of Diablo II. These instructions are only tested on
***supported versions*** of Cactus. While these instructions may work on other
versions of Windows, they are not supported.

#### Wine (FreeBSD / Linux)

If you are installing Cactus on through Wine and running on FreeBSD, Linux,
or another platform that Wine runs on, you can take a look at the instructions
located [here](README-CACTUS-ON-WINE.md). Then come back here when you are done
and follow any other applicable steps.

#### Windows 7

There are two things that you will want to have installed if you are running on
Windows 7: **Service Pack 1** and **.NET Framework 4.5.2**. This ensures you will
have the most stable experience. You can check if you have Service Pack 1 by
clicking the Start button and running **`winver`**. It should say
**`Version 6.1 (Build 7601: Service Pack 1)`**. If it says **`Version 6.1 (Build 7600)`**,
then you don't have Service Pack 1 and will need to upgrade before continuing.
You can download Service Pack 1 directly from [Microsoft](https://www.catalog.update.microsoft.com/Search.aspx?q=kb976932). I'm also hosting a copy of them for backup and convenience purposes
([Mirror A](https://themovingcaravan.com/diablo/windows/), [Mirror B](https://xyinn.org/diablo/windows/).
You only need to download and install the file for your particular bitness level
(either x86 or x64).

The second thing is **.NET Framework 4.5.2**. Windows 7 doesn't come with this version
of .NET, which Cactus needs to function. You can easily install this by running
**`NET_Framework_4.5.2_x86_x64.exe`** located in the **`3. Other`** directory.
Once it's done, reboot your machine, and continue with the instructions below.

#### Windows 7 and Windows 10

This applies to all users regardless of Windows version or bitness level (x86/x64).

1. Copy all of the files in the **`1. Files`** folder into your **`Diablo II Root Directory`**.

   - It's important that Cactus runs from inside your **`Diablo II Root Directory`**,
     or weird stuff will happen in various situations (like running **`-direct -txt`**
     mods, taking screenshots, etc).

1. If you need to fix your MPQs, then also copy the **`MpqFixer`** located in
   the **`3. Other`** directory into your **`Diablo II Root Directory`**. This
   fix is only needed if you want to play versions **`1.08 - 1.13d`** and you
   also happened to install Diablo II from the new Blizzard Installer. If you
   are not planning to play those versions, or you installed Diablo II from the
   original **`1.00, 1.03, 1.07`** discs, you don't need to fix your MPQs.

   You can then right click the **`FIX_MPQS_RUN_AS_ADMIN.bat`** located inside
   the **`MpqFixer`** directory, and click **`Run as Administrator`**.

1. Run the **`MSVC_x86_2015-2022_14.36.32532.exe`** file in the **`3. Other`**
   directory to install the required libraries for **`3D Sound / Environmental Effects`**.
   If you run the game without these being installed, you will get a **`VCRUNTIME140.dll`**
   error message. If you don't want/need this functionality, you can delete the
   **`dsoal-aldrv.dll`** and **`dsound.dll`** from your **`Diablo II Root Directory`**,
   and skip this step.

### Adding/Running A Platform

1. Open **`Cactus`**.
1. Click **`Settings`** and set your **`Diablo II Root Directory`** to your Diablo II folder. **`(Example: C:\Games\Diablo II)`**
1. Click **`Add`**.
1. Type in the name of the **`Platform`** you want to run. This should match a folder in the **`Platforms`**
   folder. (Example: If you want to run **`1.09b`**, type **`1.09b`**).
1. **`Optional (Recommended)`**: Type in a **`Label`** for this platform. If you label your platform, it will have its own dedicated
   save directory, allowing you to have multiple entries using the same platform but with different save locations.
   If you don't use a label, all the characters with this platform name will be stored in the same location (flat structure).
   You can have multiple entries using the same platform with and without labels as well. A label cannot be
   removed from an entry once created, but it can be renamed. A label cannot be added to an entry once created.
1. Enter the name of your **`Launcher`**. **`(Example: Game.exe)`**
1. **`Optional`**: Enter the Flags you want (Example: **`-ns`**).
1. **`Optional`**: Enter a note if desired. This is just for you and isn't used by the game.
1. Click **`Add`**.
1. Select your newly added Platform and press **`Launch`**.

The game should start. If you are having video issues, please make sure you
have read the [**`README-RENDERERS`**](README-RENDERERS.md) and ensure that
it was configured properly.

**`NOTE`**: Make sure to leave the Cactus application running throughout your
play sessions (you can minimize it). Cactus keeps track of the running Diablo II
processes it launches as to protect you from accidentally switching to a different
platform, and causing your **`Save Path`** to be updated to an incorrect location.

## Windows 11+ will not be supported.

Due to Microsoft mandating people to have an online connection and a Microsoft
account for Windows 11 (at the OOBE stage), any version above Windows 10 will
not be supported. Given that the Xbox One already had this exact requirement,
I'm not surprised Microsoft went in this direction for Windows as well.

- [**Source 1 - February 16, 2022 - Windows 11 Insider Preview Build 22557**](https://blogs.windows.com/windows-insider/2022/02/16/announcing-windows-11-insider-preview-build-22557/)

```
Similar to Windows 11 Home edition, Windows 11 Pro edition now requires internet
connectivity during the initial device setup (OOBE) only. If you choose to setup
device for personal use, MSA will be required for setup as well. You can expect
Microsoft Account to be required in subsequent WIP flights.
```

- [**Source 2 - May 5, 2022 - Windows 11 Insider Preview Build 22616**](https://blogs.windows.com/windows-insider/2022/05/05/announcing-windows-11-insider-preview-build-22616/)

```
Previously, we shared new requirements for internet and MSA on the Windows 11
Pro edition. Today, Windows Insiders on Windows 11 Pro edition will now require
MSA and internet connectivity during the initial device setup (OOBE) only when
setting up for personal use. If you choose to setup device for Work or School,
there is no change, and it will work the same way as before.
```

Windows 10 Pro doesn't have this requirement at all. Windows 10 Home does have
this requirement, but can be bypassed by unplugging your internet connection
before the OOBE stage. ***I'm including Windows 10 support due to there still
being a direct path to use the OS with no workarounds through the Pro edition.***
Windows 10 reaches EOL on [October 14, 2025](https://learn.microsoft.com/en-us/lifecycle/products/windows-10-home-and-pro).
However, I have gone dark already using my **Dark Island** strategy, which
means that I'm using Windows exclusively in **Offline Mode**, with all forms
of communication to the public internet disabled. I never allow it to reach
the internet from the very beginning, including during the installation stage.
I only play **Offline Single Player Games**, so this strategy works
for me, and it also means that the EOL status for Windows 7/10 won't really
affect me. At this point I'm using Windows like a N64 or Gameboy,
which is why I call this machine a ***Wintendo***. I never needed internet
for those systems then, and still don't today, yet I can still use
and play those games decades later. Going dark years before the EOL, gave me
plenty of time to make sure that I backed up everything I need, to reproduce
my environment post EOL. If you are interested in my Dark Island strategy,
you can take a look at my [blog post](https://xyinn.org/blog/windows/going_dark).

Lastly, I have exited Windows development completely, but will continue
to maintain Cactus for Windows 7/10 only. Please do not file any bug reports
if you are running my software on any other version of Windows, they will
be promptly closed as **`NOT SUPPORTED`**.

## Template & Labeling System

The Cactus Template & Labeling System allows you to be able to easily
start using a few pretty cool and very interesting workflows, while
allowing you to re-use your existing platforms, thus minimizing the
amount of disk space used.

For example, let's say we want to play **`Solo Self Found`** as defined
as **`Only using items that the character has found with their own hands`**,
this pretty much means untwinked play. However, let's say you
are also ok with using mules as a form of an extended stash for your
main character. Thus, any items your main character finds, can be placed
in storage, and will only be used by that main character specifically.
If you were to do this manually, for each particular main character you
made, it would quickly get out of hand since all the main characters and
each individual main character's set of mules, would all be in the same
folder. This is where the Templating & Labeling System kicks in. Now, we
could simply make a new entry in Cactus pointing to an existing
platform, and give it a particular label (Say the name of that specific
main character) and play the game. A dedicated save folder with the given
label will be created under the Saves directory for this platform.

For example, I want to make a character called **`Isaac`**. Isaac will
have their own set of mule characters as well and we'll call them
**`Mule_A`**, **`Mule_B`**, and **`Mule_C`** for simplicity. This
character will also be on **`1.09b`**. Thus, we can make a new entry for
our **`1.09b`** platform with the label **`Isaac`**. Once we start the
game, we will have the following structure in our Diablo II root
directory (let's assume I already made the characters in-game):

```
/Platforms/1.09b/

/Saves/1.09b/

/Saves/1.09b/Isaac/
/Saves/1.09b/Isaac/Isaac.d2s
/Saves/1.09b/Isaac/Mule_A.d2s
/Saves/1.09b/Isaac/Mule_B.d2s
/Saves/1.09b/Isaac/Mule_C.d2s
```

As you can see, this entry is fully isolated using its platform and
label combination. Now, let's say you and your friends want to have some
type of tournament on **`1.09b`**. No problem! You can quickly add
another entry for the **`1.09b`** platform with another label, such as
**`Tournament 2022`** and start it up. The same exact **`1.09b`**
platform files that we used before will be re-used, and we will have a
new save directory. Let's create a new character called **`Bethany`**
and give Bethany a few mules as well. We'll call the mules the same as
before, and since they are isolated, we can reuse the same muling naming
scheme with no conflicts. So now our structure looks like this:

```
/Platforms/1.09b/

/Saves/1.09b/

/Saves/1.09b/Isaac/
/Saves/1.09b/Isaac/Isaac.d2s
/Saves/1.09b/Isaac/Mule_A.d2s
/Saves/1.09b/Isaac/Mule_B.d2s
/Saves/1.09b/Isaac/Mule_C.d2s

/Saves/1.09b/Bethany/
/Saves/1.09b/Bethany/Bethany.d2s
/Saves/1.09b/Bethany/Mule_A.d2s
/Saves/1.09b/Bethany/Mule_B.d2s
/Saves/1.09b/Bethany/Mule_C.d2s
```

This is just one of the new workflows that our Templating & Labeling
System enables. This workflow requires a modified **`D2gfx.dll`** to
allow multiple instances of the game, allowing you to mule between
your main character and your mules via LAN. Singling provides this
feature for the versions it supports. For all other versions, you'll
need to find a copy of it online.

Another workflow which I really like is using this labeling system to
separate my **`Classic`** and **`Expansion`** characters. By using two
separate labels to the same platform, we can have two separate save
paths for them. If we did this, we would have the following:

```
/Platforms/1.09b/

/Saves/1.09b/

/Saves/1.09b/Classic/

/Saves/1.09b/Expansion/

/Saves/1.09b/Isaac/
/Saves/1.09b/Isaac/Isaac.d2s
/Saves/1.09b/Isaac/Mule_A.d2s
/Saves/1.09b/Isaac/Mule_B.d2s
/Saves/1.09b/Isaac/Mule_C.d2s

/Saves/1.09b/Bethany/
/Saves/1.09b/Bethany/Bethany.d2s
/Saves/1.09b/Bethany/Mule_A.d2s
/Saves/1.09b/Bethany/Mule_B.d2s
/Saves/1.09b/Bethany/Mule_C.d2s
```

You can pretty much label your platforms whatever you want as long as
the name can be used for the folder on your hard drive. If you are using
some illegal symbols like **`/`**, then Cactus will properly detect that
and give you the appropriate message so that you can fix it. You can
also omit the label if you want and that works perfectly fine with the
above scenarios. Let's say you wanted to have a **`1.09b`** platform and
have everything in there without caring about labels (essentially a flat
layout, although you can also have a flat layout with a label, it just
depends on how you want to organize stuff), go ahead and create an entry
with the platform name **`1.09b`** and leave the label blank. Launching
the game will just point the save path to the **`/Saves/1.09b/`** folder
and your files will be placed in there. Assuming we then created a
character called **`Leslie`**, we would then have the following
structure:

```
/Platforms/1.09b/

/Saves/1.09b/
/Saves/1.09b/Leslie.d2s

/Saves/1.09b/Classic/

/Saves/1.09b/Expansion/

/Saves/1.09b/Isaac/
/Saves/1.09b/Isaac/Isaac.d2s
/Saves/1.09b/Isaac/Mule_A.d2s
/Saves/1.09b/Isaac/Mule_B.d2s
/Saves/1.09b/Isaac/Mule_C.d2s

/Saves/1.09b/Bethany/
/Saves/1.09b/Bethany/Bethany.d2s
/Saves/1.09b/Bethany/Mule_A.d2s
/Saves/1.09b/Bethany/Mule_B.d2s
/Saves/1.09b/Bethany/Mule_C.d2s
```

It's just another folder after all ;). The nice thing about this is that
since all of these are sharing the same platform, switching between
these entries is extremely fast since no files need to change on your
hard drive, but rather we simply just update the registry save path, and
you are back in the action. Have fun!

## Backup System

By clicking the **`Backup`** button, Cactus will automatically create a backup
of the following files in the **`Backups`** directory, inside your
**`Diablo II Root Directory`**:

- **`/Platforms/`**
- **`/Saves/`**
- **`/Entries.json`**
- **`/LastRequiredFiles.json`**
- **`/Settings.json`**

The **`Backups`** directory is considered a **`Protected Directory`** by Cactus,
and will not be deleted.

Lastly, you can change the backup location to any location you have write access
to, by modifying the **`Backups Directory`** setting in the **`Settings`**.

## Using Cactus like a Service

Cactus has some basic tracking of processes that it launches in order to
ensure that there are no accidental launches of other versions or
combinations of the game that would cause your Save Path location to be
changed mid-game. Thus it is essential for Cactus to remain running
while you are playing. If you are always going to be running Diablo II
via Cactus, you may want to go into the Cactus Settings and toggle the
**`Minimize to System Tray`** option so that it doesn't take up space in
your taskbar. I personally like having it show in the taskbar but that's
just preference ;D.

## Updating Files In The Platforms folder

If you update any files in your **Platforms** folder, you'll need to click the
**`Reset`** button, and run your platform again. Clicking **`Reset`** will
cause Cactus to reconfigure itself, and running the platform again will cause
your new files to be re-installed and used.

## Moving Cactus To A New Computer

If you want to move all of your Platforms, Characters, and Diablo II folder
to another machine, you will need to:

1. Copy your entire Diablo II folder to your new computer.
1. Open **`Cactus`**.
1. Click **`Settings`** and change your **`Diablo II Root Directory`** to match the location on your new computer.
1. Click **`Reset`**.
1. Now **`Launch`** whatever Platform you want.

Clicking **`Reset`** will cause Cactus to reconfigure itself by removing
some files from your **`Diablo II Root Directory`** and wiping the
**`Last Ran`** box on the entry that has it. Once you launch the game,
the registry will point to the appropriate save location, and your platform
files will be copied back to your Diablo II root folder. In some rare cases
(only on first install), you may need to do a little bit of manual organization
in your Diablo II root folder to get things aligned properly. Once aligned,
it's all tracked and automatic.

## Unlocking All Cinematics

If you moved Cactus to a new computer, or you did a fresh install, you can unlock
all of the cinematics by doing the following:

1. Launch Diablo II, and then close it.
1. Open the Registry Editor (**`regedit.exe`**).
1. Go to **`Computer\HKEY_CURRENT_USER\SOFTWARE\Blizzard Entertainment\Diablo II`**.
1. Set the **`Aux Battle.net`** key to **`216.148.246.35`**.
1. Congrats! All of your cinematics are now unlocked.

## OMAHGOD! My Characters Are Gone! Cactus Deleted Them!!!

Cactus comes with [built in safety features](https://codeberg.org/fearedbliss/Cactus-Core/src/branch/main/Cactus/FileGenerator.cs)
specifically designed to protect critical directories and files, which
includes the save directories. Thus it is impossible for Cactus to have
deleted them. Cactus also only operates within the Diablo II root
directory so it also wouldn't be possible for Cactus to delete saves
that are in **`1.14d+`**'s new save directory that is in your personal
folder.

Since Cactus is **`A Modern Version Switcher, Character Isolator, and Mod Manager`**,
it will update the registry location of where the game should look for the
saves. For example, if you are playing a **`Platform`** called
**`1.05b`** with a **`Label`** called **`Chinchilla`**, the files for
this platform would logically be located under **`Platforms/1.05b/`**,
and the saves would be located under **`Saves/1.05b/Chinchilla/`**. Both
directories are located inside your Diablo II folder. Thus, when the
game starts, your characters are properly isolated and protected. If
this is the first time you launched a game with Cactus, and you
previously just had a regular Diablo II installation, then it would seem
as if all your characters got deleted, or magically dissapeared.
However, they are simply located in the original location that your
computer saved them to. If you were playing **`1.14d+`**, they most
likely are located at:

**`%USERPROFILE%/Saved Games/Diablo II`**

If you were playing **`1.13d`** or below, they are inside the Diablo II
folder itself under a folder called **`save`**.

Lastly, always remember to keep backups when running Third Party Tools
or Modifications.

## Cactus switches versions but I don't see the Diablo II window and there are no errors either.

If switching versions with Cactus doesn't actually launch the game but you also
don't notice any errors, this could be an indication that either your Video Settings
are not correct, or that you may need to run Cactus in Admin Mode. I've noticed that
if I have Diablo II installed on the **`C:\`** drive (i.e **`C:\Games\Diablo II`**),
I would need to run Cactus at least once in Admin Mode for it to work properly, but
if I installed Diablo II on another drive (i.e **`D:\Games\Diablo II`**), it would
work fine without Admin privileges. I'm pretty sure this is due to the **`C:\`**
drive generally being a protected drive.

Another thing to note is that I observed that I only needed to run Cactus once in Admin
Mode for this to "stick" and continue working even if I opened Cactus in the future without
Admin rights, although I haven't tested if this persists across reboots, but it possibly may.
I've also noticed that even when there was a problem, some versions would work,
and some wouldn't. Specifically versions **`1.00 - 1.06b`** worked, but **`1.07 - 1.13d`**
didn't.

Lastly, make sure that there are no zombie Diablo II processes running in the background (Task Manager),
that can cause the version switcher to either not switch away or something else. I know that
the new telemetry executables added to **`1.14d`** (i.e **`SystemSurvey.exe`** and **`BlizzardError.exe`**)
are not needed for the game to actually function, and can lock the process for a bit after you close
the game. The Cactus platforms do not contain these files since I've deleted them, however, if you
are installing from a fresh copy of Diablo II from Blizzard, it will have them.

## Game Screenshots

![1.00](https://i.imgur.com/uugMn48.jpg)
![1.05b](https://i.imgur.com/901u4V7.jpg)
![1.07](https://i.imgur.com/zHD9s5L.jpg)
![1.08](https://i.imgur.com/sUiFKqN.jpg)
![1.09b](https://i.imgur.com/JZ9bIOy.jpg)
![1.10](https://i.imgur.com/Vw4yaDM.jpg)
![1.13d](https://i.imgur.com/XiQheXy.jpg)
![1.14d](https://i.imgur.com/R55ZxVW.jpeg)
