# Setting up Cactus with Wine (FreeBSD / Linux)

The following will show you how to set up Cactus to run on Wine. This means that
any platform that supports Wine will be able to run Cactus and Diablo II. Some
things keep in mind:

- Diablo II is a 32 bit application that was made for older versions of Windows.
  Thus we will be using a 32 bit prefix that is set to Windows XP compatibility
  mode for all of our tests, in order to provide the best environment possible
  for the game. It may work with older compatibility versions as well, but
  Windows XP is a good target. I've also tested it in a 64 bit prefix and it
  works perfectly fine.
- Cactus is a C# application that targets .NET Framework 4.5.2. Thus, we will be
  using Wine Mono to provide that functionality.
- You should be running everything through X11 for the best experience.
  Everything seems to work perfectly fine through XWayland on Wine 10.0.0,
  however when I upgraded to a newer version of Wine, Cactus was having issues
  being rendered in Wine via XWayland and also its native Wayland driver. There
  seems to be a regression in Wine which upstream needs to fix. However, I'm open
  to customizing the Cactus launch script mentioned below to increase the chances
  of Cactus running properly. There will ***not*** be any modifications made to
  Cactus itself.
- Cactus and all versions of Diablo II between 1.00 - 1.13d will work perfectly
  fine with no issues through Wine. 1.14d does not work using cnc-ddraw's proxy
  dlls. If you are planning on playing mods in the Cactus Ports Collection, due
  note that there is a chance that it won't work, or may have stability issues
  during gameplay. This is because mods created by the community have a lot of
  custom modifications that are highly Windows specific, and may cause issues
  when running through Wine. There will definitely be many mods that work with
  no issues though, but you'll need to experiment on your side. Cactus Ports
  Collection mods are only guaranteed to work as described on Windows.

## Tested On

This has been ***tested*** with the following configurations:

### FreeBSD

- Operating System: **`FreeBSD 14.3-PRERELEASE (stable/14-n271160-d41725ab4301 GENERIC amd64)`**
- Wine Version: **`10.4`**
- Wine Mono Version: **`10.0.0`**
- Prefix Bitness: **`32 bit`**
- Display Server: **`X11`**

![Cactus](https://i.imgur.com/VMkoSFZ.png)

### Linux

- Operating System: **`Linux Mint 22.1 (6.8.0-58-generic x86_64)`**
- Wine Version: **`10.6`**
- Wine Mono Version: **`10.0.0`**
- Prefix Bitness: **`32 bit`**
- Display Server: **`X11`**

![Cactus](https://i.imgur.com/SlpiHKR.png)

## Steps

1. Install **`wine`** and **`wine-mono`** with whatever mechanism your OS or
   distribution provides.

1. Create a **`32 bit`** prefix directory and configure it. We will assume your
   prefix is in **`$HOME/prefix/cactus`**, adjust to your tastes.
   
   ```
   $ mkdir -p "$HOME/prefix/cactus/drive_c/Games/Diablo II"
   $ WINEPREFIX="$HOME/prefix/cactus" WINEARCH=win32 wine winecfg
   ```
   
1. Once the wine configuration screen pops up, change the following settings:

   - **`Applications -> Windows Version: Windows XP`**
   - Press **`Ok`**.

1. Copy your **`Diablo II`** and **`Cactus`** files into
   **`$HOME/prefix/cactus/drive_c/Games/Diablo II`**. This is your
   ***Diablo II Root Directory***, and is considered
   **`C:\Games\Diablo II`** when running Cactus.

1. You should now be able to launch Cactus and configure it as normal, by
   running it from our prefix. You could either make your own launcher, or you
   can put the following convenience script anywhere you like:
   
   ```
    #!/bin/sh

    PREFIX_NAME="cactus"
    PREFIX_BASE_PATH="$HOME/prefix"
    PREFIX_DIRECTORY="$PREFIX_BASE_PATH/$PREFIX_NAME"
    D2_ROOT_DIRECTORY="$PREFIX_DIRECTORY/drive_c/Games/Diablo II/"
    CACTUS_EXE="Cactus.exe"

    # If running under Wayland, this will unset the DISPLAY variable which will
    # cause Wine to use its native wayland driver, instead of relying on XWayland.
    # Cactus works perfectly fine through Wine using X11. Due note that Wine's
    # Wayland and XWayland support is spotty and you most likely will experience
    # issues or regressions. This is a problem that's fully on Wine to fix. This
    # flag is provided to help test Cactus in these situations. I'm open to
    # tweaking this script to allow it to launch successfully. But no changes to
    # Cactus itself will be made.
    USE_NATIVE_WAYLAND_DRIVER=0

    if [ $USE_NATIVE_WAYLAND_DRIVER -eq 1 ]; then
        export DISPLAY=
    fi

    export WINEPREFIX="$PREFIX_DIRECTORY"
    export WINEDLLOVERRIDES="ddraw,dsound=n"

    # Always switch to the Diablo II Root Directory before launching Cactus.
    cd "$D2_ROOT_DIRECTORY"

    wine "$CACTUS_EXE" &
    ```
    
   Once we are done, we need to give it execute permissions, and run it. Assuming
   we saved the file as **`cactus.sh`**, you can do the following:
   
   ```
   $ chmod u+x cactus.sh
   $ ./cactus.sh
   ```

   You should be able to run any version of Diablo II (except 1.14) with no issues.

1. Enjoy.